// Copyright 2014 Google Inc. All Rights Reserved.

#include "Log.h"
#include "Thread.h"
#include <sys/prctl.h>

void* Thread::callback(void* arg) {
    Thread* thread = (Thread*) arg;
    thread->run();
    return NULL;
}

Thread::~Thread() {
    if (mRunning) {
        LOGW("Thread %lx went out of scope while running!", (unsigned long) mThread);
    }
}

bool Thread::start() {
    /* Changed by ADIT
     * TODO:
     * Think about how to name the threads.
     */
    int ret = pthread_create(&mThread, NULL,
            [](void* a)->void* {
                prctl(PR_SET_NAME, "GalReceiverThread", 0, 0, 0);
                callback(a);
                return nullptr;
            }
    , this);


    mRunning = (ret == 0);
    return mRunning;
}

bool Thread::join() {
    if (!mRunning) {
        return false;
    }
    int ret = pthread_join(mThread, NULL);
    if (ret == 0) {
        mRunning = false;
        return true;
    }
    return false;
}

unsigned long Thread::id() {
    return (unsigned long) mThread;
}

void Thread::yield() {
    sched_yield();
}

bool Thread::setPriority(int priority) {
    struct sched_param params;
    params.sched_priority = priority;
    int ret = pthread_setschedparam(mThread, SCHED_FIFO, &params);
    return ret == 0;
}

bool Thread::setName(const char* name) {
    return pthread_setname_np(mThread, name) == 0;
}
